unit ResXMainForm;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data, System.Resources,
  System.Runtime.InteropServices;

type
  TResXMainForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    mainMenu: System.Windows.Forms.MainMenu;
    OpenFileDialog: System.Windows.Forms.OpenFileDialog;
    mniFile: System.Windows.Forms.MenuItem;
    mniWindow: System.Windows.Forms.MenuItem;
    mniHelp: System.Windows.Forms.MenuItem;
    mniNew: System.Windows.Forms.MenuItem;
    mniClose: System.Windows.Forms.MenuItem;
    mniCascade: System.Windows.Forms.MenuItem;
    mniTile: System.Windows.Forms.MenuItem;
    mniArrangeIcon: System.Windows.Forms.MenuItem;
    mniMinimizeAll: System.Windows.Forms.MenuItem;
    mniCloseAll: System.Windows.Forms.MenuItem;
    mniAbout: System.Windows.Forms.MenuItem;
    mniOpen: System.Windows.Forms.MenuItem;
    mniSeparator: System.Windows.Forms.MenuItem;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure mniAbout_Click(sender: System.Object; e: System.EventArgs);
    procedure mniOpen_Click(sender: System.Object; e: System.EventArgs);
    procedure mniNew_Click(sender: System.Object; e: System.EventArgs);
    procedure mniClose_Click(sender: System.Object; e: System.EventArgs);
    procedure mniCascade_Click(sender: System.Object; e: System.EventArgs);
    procedure mniTile_Click(sender: System.Object; e: System.EventArgs);
    procedure mniArrangeIcon_Click(sender: System.Object; e: System.EventArgs);
    procedure mniMinimizeAll_Click(sender: System.Object; e: System.EventArgs);
    procedure mniCloseAll_Click(sender: System.Object; e: System.EventArgs);
    procedure mniWindow_Select(sender: System.Object; e: System.EventArgs);
    procedure TResXMainForm_DragDrop(sender: System.Object; e: System.Windows.Forms.DragEventArgs);
    procedure TResXMainForm_DragEnter(sender: System.Object; e: System.Windows.Forms.DragEventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  public
    constructor Create;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TResXMainForm))]

implementation

uses
  System.IO,
  System.Globalization,
  ResXChildForm,
  AboutForm;

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support - do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TResXMainForm.InitializeComponent;
type
  TSystem_Windows_Forms_MenuItemArray = array of System.Windows.Forms.MenuItem;
var
  resources: System.Resources.ResourceManager;
begin
  resources := System.Resources.ResourceManager.Create(TypeOf(TResXMainForm));
  Self.mainMenu := System.Windows.Forms.MainMenu.Create;
  Self.mniFile := System.Windows.Forms.MenuItem.Create;
  Self.mniNew := System.Windows.Forms.MenuItem.Create;
  Self.mniOpen := System.Windows.Forms.MenuItem.Create;
  Self.mniSeparator := System.Windows.Forms.MenuItem.Create;
  Self.mniClose := System.Windows.Forms.MenuItem.Create;
  Self.mniWindow := System.Windows.Forms.MenuItem.Create;
  Self.mniCascade := System.Windows.Forms.MenuItem.Create;
  Self.mniTile := System.Windows.Forms.MenuItem.Create;
  Self.mniArrangeIcon := System.Windows.Forms.MenuItem.Create;
  Self.mniMinimizeAll := System.Windows.Forms.MenuItem.Create;
  Self.mniCloseAll := System.Windows.Forms.MenuItem.Create;
  Self.mniHelp := System.Windows.Forms.MenuItem.Create;
  Self.mniAbout := System.Windows.Forms.MenuItem.Create;
  Self.OpenFileDialog := System.Windows.Forms.OpenFileDialog.Create;
  // 
  // mainMenu
  // 
  Self.mainMenu.MenuItems.AddRange(TSystem_Windows_Forms_MenuItemArray.Create(Self.mniFile, 
          Self.mniWindow, Self.mniHelp));
  // 
  // mniFile
  // 
  Self.mniFile.Index := 0;
  Self.mniFile.MenuItems.AddRange(TSystem_Windows_Forms_MenuItemArray.Create(Self.mniNew, 
          Self.mniOpen, Self.mniSeparator, Self.mniClose));
  Self.mniFile.MergeType := System.Windows.Forms.MenuMerge.MergeItems;
  Self.mniFile.Text := '&File';
  // 
  // mniNew
  // 
  Self.mniNew.Index := 0;
  Self.mniNew.Text := '&New';
  Include(Self.mniNew.Click, Self.mniNew_Click);
  // 
  // mniOpen
  // 
  Self.mniOpen.Index := 1;
  Self.mniOpen.Text := '&Open';
  Include(Self.mniOpen.Click, Self.mniOpen_Click);
  // 
  // mniSeparator
  // 
  Self.mniSeparator.Index := 2;
  Self.mniSeparator.MergeOrder := 2;
  Self.mniSeparator.Text := '-';
  // 
  // mniClose
  // 
  Self.mniClose.Index := 3;
  Self.mniClose.MergeOrder := 2;
  Self.mniClose.Text := 'E&xit';
  Include(Self.mniClose.Click, Self.mniClose_Click);
  // 
  // mniWindow
  // 
  Self.mniWindow.Index := 1;
  Self.mniWindow.MenuItems.AddRange(TSystem_Windows_Forms_MenuItemArray.Create(Self.mniCascade, 
          Self.mniTile, Self.mniArrangeIcon, Self.mniMinimizeAll, Self.mniCloseAll));
  Self.mniWindow.MergeOrder := 4;
  Self.mniWindow.Text := '&Window';
  Include(Self.mniWindow.Select, Self.mniWindow_Select);
  // 
  // mniCascade
  // 
  Self.mniCascade.Index := 0;
  Self.mniCascade.Text := '&Cascade';
  Include(Self.mniCascade.Click, Self.mniCascade_Click);
  // 
  // mniTile
  // 
  Self.mniTile.Index := 1;
  Self.mniTile.Text := '&Tile';
  Include(Self.mniTile.Click, Self.mniTile_Click);
  // 
  // mniArrangeIcon
  // 
  Self.mniArrangeIcon.Index := 2;
  Self.mniArrangeIcon.Text := '&Arrange Icon';
  Include(Self.mniArrangeIcon.Click, Self.mniArrangeIcon_Click);
  // 
  // mniMinimizeAll
  // 
  Self.mniMinimizeAll.Index := 3;
  Self.mniMinimizeAll.Text := '&Minimize All';
  Include(Self.mniMinimizeAll.Click, Self.mniMinimizeAll_Click);
  // 
  // mniCloseAll
  // 
  Self.mniCloseAll.Index := 4;
  Self.mniCloseAll.Text := '&Close All';
  Include(Self.mniCloseAll.Click, Self.mniCloseAll_Click);
  // 
  // mniHelp
  // 
  Self.mniHelp.Index := 2;
  Self.mniHelp.MenuItems.AddRange(TSystem_Windows_Forms_MenuItemArray.Create(Self.mniAbout));
  Self.mniHelp.MergeOrder := 5;
  Self.mniHelp.Text := '&Help';
  // 
  // mniAbout
  // 
  Self.mniAbout.Index := 0;
  Self.mniAbout.Text := '&About';
  Include(Self.mniAbout.Click, Self.mniAbout_Click);
  // 
  // TResXMainForm
  // 
  Self.AllowDrop := True;
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.BackColor := System.Drawing.SystemColors.AppWorkspace;
  Self.ClientSize := System.Drawing.Size.Create(569, 384);
  Self.Icon := (System.Drawing.Icon(resources.GetObject('$this.Icon')));
  Self.IsMdiContainer := True;
  Self.Menu := Self.mainMenu;
  Self.Name := 'TResXMainForm';
  Self.StartPosition := System.Windows.Forms.FormStartPosition.CenterScreen;
  Self.Text := 'ResXBuilder for Delphi 8 for .NET';
  Include(Self.DragDrop, Self.TResXMainForm_DragDrop);
  Include(Self.DragEnter, Self.TResXMainForm_DragEnter);
end;
{$ENDREGION}

procedure TResXMainForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TResXMainForm.Create;
begin
  inherited Create;
  InitializeComponent;
end;

procedure TResXMainForm.TResXMainForm_DragEnter(sender: System.Object; e: System.Windows.Forms.DragEventArgs);
begin
  // Make sure they're actually dropping files (not text or anything else).
  if( e.Data.GetDataPresent(DataFormats.FileDrop, false) = true ) then
  // Allow them to continue (without this, the cursor stays a "NO" symbol
    e.Effect := DragDropEffects.All;
end;

procedure TResXMainForm.TResXMainForm_DragDrop(sender: System.Object; e: System.Windows.Forms.DragEventArgs);
type
  TArrayString = array of string;
var
  files: TArrayString;
  i: Integer;
  newForm: TResXChildForm;
begin
  // Transfer the filenames to a string array
  // (yes, everything to the left of the "=" can be put in the
  // foreach loop in place of "files", but this is easier to understand.)
  files := TArrayString(e.Data.GetData(DataFormats.FileDrop));
  for i := 0 to Length(files) -1 do
    if System.IO.Path.GetExtension(files[i]) = '.resx' then
    begin
      newForm := TResXChildForm.Create;
      newForm.MdiParent := Self;
      newForm.OpenFile(files[i]);
      newForm.Show;
      Break;
    end;
end;

procedure TResXMainForm.mniWindow_Select(sender: System.Object; e: System.EventArgs);
var
  IsActive: Boolean;
begin
  IsActive := ActiveMdiChild <> nil;
  mniCascade.Enabled := IsActive;
  mniTile.Enabled := IsActive;
	mniArrangeIcon.Enabled := IsActive;
  mniMinimizeAll.Enabled := IsActive;
  mniCloseAll.Enabled := IsActive;
end;

procedure TResXMainForm.mniCloseAll_Click(sender: System.Object; e: System.EventArgs);
var
  i: Integer;
  Children: array of Form;
begin
  Children := Self.MdiChildren;
  for i := 0 to  Length(Children) - 1 do
    Children[i].Close;
end;

procedure TResXMainForm.mniMinimizeAll_Click(sender: System.Object; e: System.EventArgs);
var
  i: Integer;
  Children: array of Form;
begin
  Children := Self.MdiChildren;
  for i := 0 to  Length(Children) - 1 do
    Children[i].WindowState := FormWindowState.Minimized;
end;

procedure TResXMainForm.mniArrangeIcon_Click(sender: System.Object; e: System.EventArgs);
begin
  LayoutMdi(MdiLayout.ArrangeIcons);
end;

procedure TResXMainForm.mniTile_Click(sender: System.Object; e: System.EventArgs);
begin
  LayoutMdi(MdiLayout.TileHorizontal);
end;

procedure TResXMainForm.mniCascade_Click(sender: System.Object; e: System.EventArgs);
begin
  LayoutMdi(MdiLayout.Cascade);
end;

procedure TResXMainForm.mniClose_Click(sender: System.Object; e: System.EventArgs);
begin
  Close;
end;

procedure TResXMainForm.mniNew_Click(sender: System.Object; e: System.EventArgs);
var
  newForm: TResXChildForm;
begin
  newForm := TResXChildForm.Create;
  newForm.MdiParent := Self;
  newForm.Show;
end;

procedure TResXMainForm.mniOpen_Click(sender: System.Object; e: System.EventArgs);
var
  newForm: TResXChildForm;
begin
  OpenFileDialog.FileName := '';

  OpenFileDialog.Filter := 'Resource (*.resx)|*.resx|All Files (*.*)|*.*';
  OpenFileDialog.DefaultExt := 'resx';

  if OpenFileDialog.ShowDialog = System.Windows.Forms.DialogResult.OK then
	begin
    newForm := TResXChildForm.Create;
    newForm.MdiParent := Self;
    newForm.OpenFile(OpenFileDialog.FileName);
    newForm.Show;
	end;
end;

procedure TResXMainForm.mniAbout_Click(sender: System.Object; e: System.EventArgs);
var
  about: TAboutBox;
begin
  about := TAboutBox.Create;
  about.ShowDialog;
end;

end.
